import React from "react";
import {NavLink as RouterNavLink} from "react-router-dom";
import {
  Container,
  Nav,
  Navbar,
  NavbarBrand,
} from "reactstrap";
import Menu from "./Menus/Menu";
import UserMenu from "./Menus/UserMenu";

const Toolbar = ({user, logout}) => {
  return (
    <Navbar color="dark" dark expand="md">
      <Container>
        <NavbarBrand tag={RouterNavLink} to="/">Some market</NavbarBrand>

        <Nav className="ml-auto" navbar>
          
          {
            user ?
              <UserMenu user={user} logout={logout} />
              :
              <>
                <Menu />
              </>
          }

        </Nav>
      </Container>
    </Navbar>
  );
};

export default Toolbar;
