const mongoose = require('mongoose');

const Schema = mongoose.Schema;

const ProductSchema = new Schema({
  author: {
    type: Schema.Types.ObjectId,
    ref: 'User',
    required: true
  },
  category: {
    type: Schema.Types.ObjectId,
    ref: 'Category',
    required: true
  },
  title: {
    type: String,
    required: true
  },
  description: {
    required: true,
    type: String
  },
  image: {
    required: true,
    type: String
  },
  price: {
    required: true,
    type: Number
  }
});

const Product = mongoose.model("Product", ProductChema);

module.exports = Product;
