const express = require("express");
const multer = require("multer");
const path = require("path");
const {nanoid} = require("nanoid");
const config = require("../config");
const Product = require("../models/Product");
const auth = require("../middleware/auth");
const router = express.Router();

const storage = multer.diskStorage({
  destination: (req, file, cb) => {
    cb(null, config.uploadPath);
  },
  filename: (req, file, cb) => {
    cb(null, nanoid() + path.extname(file.originalname));
  }
});

const upload = multer({storage});

const createRouter = () => {
  router.get("/", async (req, res) => {
    let category;
    if (req.query.category) {
      category = {category: req.query.category};
    }
    try {
      const products = await Product.find(category).populate("category", "title");
      res.send(products);
    } catch (e) {
      res.sendStatus(500);
    }
  });

  router.get("/:id", async (req, res) => {
    const product = await Product.findById(req.params.id).populate("category");
    res.send(product);
  });

  router.post("/", [upload.single("image"), auth], async (req, res) => {
    const product = new Product(req.body);
    if (req.file) {
      product.image = req.file.filename;
    }
    await product.save();
    res.send(product);
  });


  router.delete("/:id", async (req, res) => {
    try {
      res.send(await Product.findByIdAndRemove(req.params.id));
    } catch(e) {res.status(500).send(e)}
  });


  return router;
};


module.exports = createRouter;


