const mongoose = require('mongoose');
const config = require('./config');

const Category = require('./models/Category');
const Product = require('./models/Product');
const User = require('./models/User');

mongoose.connect(config.db.url + '/' + config.db.name);

const db = mongoose.connection;

db.once('open', async () => {
  try {
    await db.dropCollection('users');
    await db.dropCollection('categories');
    await db.dropCollection('products');
  } catch (e) {
    console.log('Collections were not present, skipping drop...');
  }
  const[user1, user2] = await User.create({
    username: 'user',
    password: 'user',
    displayName: 'Some User',
    phone: '+949205234052',
    token: ''
  }, {
    username: 'user2',
    password: 'user2',
    displayName: 'Some User 2',
    phone: '+324013248105',
    token: ''
  });

  const [category1, category2] = await Category.create({
    title: "some category",
  },{
    title: "some category 2"
  });

  await Product.create({
    author: user2._id,
    category: category1._id,
    title: 'some product',
    description: 'some description  for some product',
    image: 'somePhoto.jpeg',
    price: 222
  },{
    author: user1._id,
    category: category2._id,
    title: 'some product 2',
    description: 'some description for some product 2',
    image: 'somePhoto1.jpeg',
    price: 154
  });

  db.close();
});
