from django import forms


class GenreForm(forms.Form):
    title = forms.CharField(
        required=True,
        max_length=50,
        min_length=3,
        label="Название жанра",
        widget=forms.TextInput(attrs={
            "class": 'form-control',
            "placeholder": "Название"
        })
    )
    description = forms.CharField(
        required=False,
        max_length=500,
        label="Описание",
        widget=forms.Textarea(attrs={
            "class": 'form-control',
            "rows": '3'
        }),
    )

    class Meta:
        fields = ['title', 'description']

