from django.shortcuts import render, redirect
from article.models import Genre
from article.forms.genre_form import GenreForm


def genre_create_view(request):
    if request.method == 'GET':
        form = GenreForm()
        return render(request, 'genre/create.html', context={'form': form})
    if request.method == 'POST':
        form = GenreForm(request.POST)
        if form.is_valid():
            genre = Genre.objects.create(
                title=form.cleaned_data.get('title'),
                description=form.cleaned_data.get('description')
            )
            genre.save()
            return redirect('list_genre')
        else:
            return render(request, 'genre/create.html', context={'form': form})

    # if request.method == 'POST':
    #     form = GenreForm(request.POST)
    #
    #     if form.is_valid():
    #         genre = Genre.objects.create(
    #             title=form.cleaned_data['title'],
    #             description=form.cleaned_data['description']
    #         )
    #         genre.save()
    #         return redirect('list_genre')
    #
    #     return render(request, 'genre/create.html', context={'form': form})


def genre_list_view(request):
    return render(request, 'genre/list.html', context={'genres': Genre.objects.all()})
