from datetime import datetime

from django.http import HttpResponseNotFound
from django.shortcuts import render, redirect

from article.models import Author, Article

def index_view(request):
    return render(request, 'index.html')

def article_create_view(request):
    if request.method == 'GET':
        return render(request, 'article/create.html', context={
            'authors': Author.objects.all()
        })
    elif request.method == 'POST':
        publication_date = datetime.strptime(request.POST.get("publication_date"), "%Y-%m-%dT%H:%M")
        now_time = datetime.now()
        if publication_date < datetime.now():
            return render(request, 'article/create.html', context={
                "error_message": f"Дата публикации ({publication_date}) не должна быть раньше текущей {now_time}"})
        author = Author.objects.get(id=request.POST.get('author_id'))
        new_article = Article.objects.create(
            title=request.POST.get('title'),
            content=request.POST.get('content'),
            author=author,
            publication_date=publication_date
        )
        new_article.save()
        return redirect('article_detail', pk=new_article.pk)


def article_detail_view(request, *args, **kwargs):
    try:
        article = Article.objects.get(pk=kwargs.get('pk'))
    except Article.DoesNotExist as e:
        return HttpResponseNotFound(f'Статья с id {kwargs.get("pk")} не найдена')
    return render(request, 'article/detail.html', context={'article': article})


def article_update_view(request, pk):
    article = Article.objects.get(pk=pk)
    if request.method == 'GET':
        publication_date_format = article.publication_date
        article.publication_date = publication_date_format.strftime('%Y-%m-%dT%H:%M')
        return render(request, 'article/update.html', context={'article': article})
    if request.method == 'POST':
        publication_date = datetime.strptime(request.POST.get("publication_date"), "%Y-%m-%dT%H:%M")
        now_time = datetime.now()
        if publication_date < datetime.now():
            return render(request, 'article/update.html', context={
                "error_message": f"Дата публикации ({publication_date}) не должна быть раньше текущей {now_time}"})

        article.title = request.POST.get('title'),
        print(request.POST.get('title'))
        article.content = request.POST.get('content'),
        article.author = request.POST.get('author'),
        article.publication_date = publication_date

        article.save()
        return redirect('article_detail', pk=article.pk)


def article_list_view(request):
    return render(request, 'article/list.html', context={
        'articles': Article.objects.all()
    })