from django.urls import path
from article.views.article_views import \
    article_create_view, \
    article_list_view, \
    article_detail_view, \
    article_update_view

from article.views.author_view import \
    author_list_view, \
    author_create_view, \
    author_update_view

from article.views.genre_view import (
    genre_create_view,
    genre_list_view
)

urlpatterns = [
    path('add/', article_create_view, name='add_article'),
    path('list/', article_list_view, name='article_list'),
    path('detail/<int:pk>', article_detail_view, name='article_detail'),
    path('edit/<int:pk>', article_update_view, name='article_update'),

    path('author/create', author_create_view, name="add_author"),
    path('author/list', author_list_view, name="list_author"),
    path('author/<int:pk>/edit', author_update_view, name="update_author"),

    path('genre/create', genre_create_view, name="add_genre"),
    path('genre/list', genre_list_view, name="list_genre"),
]
