from django.shortcuts import render, redirect, get_object_or_404
from django.urls import reverse

from article.models import Author


def author_create_view(request):
    if request.method == "GET":
        return render(request, 'author/create.html', context={
            'link': reverse('add_author'),
            'button_title': "Создать"
        })
    if request.method == "POST":
        new_author = Author.objects.create(
            last_name=request.POST.get("last_name"),
            name=request.POST.get("name"),
        )

        new_author.save()

        return redirect("list_author")


def author_list_view(request):
    return render(request, "author/list.html", context={"authors": Author.objects.all()})


def author_update_view(request, pk):
    if request.method == 'GET':
        print(reverse('update_author', kwargs={'pk': pk}))
        return render(request, 'author/create.html', context={
            'author': get_object_or_404(Author, pk=pk),
            'link': reverse('update_author', kwargs={'pk': pk}),
            'button_title': "Изменить"
        })
    if request.method == 'POST':
        author = get_object_or_404(Author, pk=pk)
        author.name = request.POST.get('name')
        author.last_name = request.POST.get('last_name')

        errors = dict()
        if len(author.name) > 100:
            errors["name"] = "Слишком длинное имя автора"
        if len(author.last_name) > 100:
            errors["last_name"] = "Слишком длинная фамилия автора"

        if errors:
            return render(request, 'author/create.html', context={
                "errors": errors,
                'author': author,
                'link': reverse('update_author', kwargs={'pk': pk}),
                'button_title': "Изменить"})

        author.save()
        return redirect('list_author')