from django.db import models


class Author(models.Model):
    name = models.CharField(max_length=100, null=False, blank=False, verbose_name='Имя')
    last_name = models.CharField(max_length=100, null=False, blank=False, verbose_name='Название')

    def __str__(self):
        return f"{self.name} {self.last_name}"


class Genre(models.Model):
    title = models.CharField(max_length=50, null=False, blank=False, verbose_name='Название', )
    description = models.CharField(max_length=100, null=False, blank=False, verbose_name='Описание')

    def __str__(self):
        return f"{self.pk}. {self.title}"


class Article(models.Model):
    title = models.CharField(max_length=100, null=False, blank=False, verbose_name='Название')
    content = models.TextField(max_length=3000, null=False, blank=False, verbose_name='Тело')
    author = models.ForeignKey(to=Author, on_delete=models.CASCADE, verbose_name='Автор')
    created_at = models.DateTimeField(auto_now_add=True, verbose_name="Дата и время создания")
    updated_at = models.DateTimeField(auto_now=True, verbose_name="Дата и время изменения")
    publication_date = models.DateTimeField(verbose_name="Дата и время публикации", null=True, blank=False)

    def __str__(self):
        return f"{self.pk}. {self.title}"

    class Meta:
        verbose_name = 'Статья'
        verbose_name_plural = 'Статьи'
