from django import forms

from article.models import Genre


class GenreForm(forms.Form):
    title = forms.CharField(
        required=True,
        max_length=50,
        min_length=3,
        label="Название жанра")
    description = forms.CharField(required=False, max_length=500, label="Описание", widget=forms.Textarea(attrs={'style': 'border: 2px solid red'}))

    class Meta:
        fields = ['title', 'description']

