from django.shortcuts import render
from article.models import Article


def index_view(request):
    return render(request, 'index.html')


def article_create_view(request):
    if request.method == 'GET':
        return render(request, 'article/create.html')
    elif request.method == 'POST':
        new_article = Article.objects.create(
            title=request.POST.get('title'),
            content=request.POST.get('content'),
            author=request.POST.get('author')
        )
        new_article.save()
        articles_list = Article.objects.all()
        return render(request, 'article/list.html', context={
            'articles': articles_list
        })


def article_list_view(request):
    articles_list = Article.objects.all()
    return render(request, 'article/list.html', context={
        'articles': articles_list
    })