from django.urls import path
from .views import (
    article_list_view,
    create_author_view,
    author_list_view, author_edit_view, author_delete_view, AuthorView
)

urlpatterns = [
    path(
        '',
        article_list_view,
        name="article_list"
    ),
    path(
        'create/',
        AuthorView.as_view(),
        name="author_create"
    ),
    path(
        'authors/',
        author_list_view,
        name="author_list"
    ),

    path(
        'author/<int:pk>/update/',
        author_edit_view,
        name="author_update"
    ),

    path(
        'author/<int:pk>/delete/',
        author_delete_view,
        name="author_delete"
    )
]
