from django.shortcuts import render, redirect, get_object_or_404
from django.views import View

from articles.models import Article, Author
from .forms import AuthorForm


def article_list_view(request):
    if request.method == "GET":
        articles = Article.objects.all()
        return render(
            request,
            template_name="articles/article_list.html",
            context={'articles': articles}
        )


def author_list_view(request):
    if request.method == "GET":
        authors = Author.objects.all()
        return render(
            request,
            template_name="authors/author_list.html",
            context={'authors': authors}
        )


class AuthorView(View):
    url_pattern = 'authors/author_create.html'

    def get(self, request, *args, **kwargs):
        form = AuthorForm()

        return render(
            request,
            self.url_pattern,
            context={'form': form})

    def post(self, request, *args, **kwargs):
        form = AuthorForm(request.POST)
        if form.is_valid():
            form.save()
        return redirect('author_list')


def create_author_view(request):
    if request.method == "GET":
        form = AuthorForm()
        return render(
            request,
            'authors/author_create.html',
            context={'form': form})
    if request.method == "POST":
        form = AuthorForm(request.POST)
        if form.is_valid():
            form.save()
        return redirect('author_list')


def author_edit_view(request, pk):
    author = get_object_or_404(Author, pk=pk)
    if request.method == "GET":
        form = AuthorForm(instance=author)
        return render(
            request,
            'authors/author_update.html',
            context={'form': form, "pk": pk})
    if request.method == "POST":
        form = AuthorForm(request.POST)
        if form.is_valid():
            author.name = request.POST.get("name")
            author.save(update_fields=['name', ])
        return redirect('author_list')


def author_delete_view(request, pk):
    if request.method == "GET":
        author = get_object_or_404(Author, pk=pk)
        author.delete()
        return redirect('author_list')
