from django.urls import path
from .views import (
    article_list_view,
    ArticleDetailView, CommentView,
    author_list_view, author_edit_view, author_delete_view, AuthorView, CreateArticleView, ArticleUpdateView
)

urlpatterns = [
    path(
        '',
        article_list_view,
        name="article_list"
    ),
    path(
        'article/<int:pk>/',
        ArticleDetailView.as_view(),
        name="article_detail"
    ),
    path(
        'article/<int:article_pk>/comment/add/',
        CommentView.as_view(),
        name="add_comment"
    ),
    path(
        'article/create/',
        CreateArticleView.as_view(),
        name='article_create'
    ),
    path(
        'article/<int:pk>/update',
        ArticleUpdateView.as_view(),
        name='article_update'
    ),
    path(
        'create/',
        AuthorView.as_view(),
        name="author_create"
    ),
    path(
        'authors/',
        author_list_view,
        name="author_list"
    ),

    path(
        'author/<int:pk>/update/',
        author_edit_view,
        name="author_update"
    ),

    path(
        'author/<int:pk>/delete/',
        author_delete_view,
        name="author_delete"
    )
]
