from django.core.exceptions import ValidationError
from django.forms.models import ModelForm
from django.forms import CharField

from articles.models import Article, Author, Comment


def at_least_10(string):
    if len(string) < 10:
        raise ValidationError("Имя слишком короткое")


class AuthorForm(ModelForm):
    name = CharField(max_length=200, required=True, label='Имя автора', validators=(at_least_10,))

    class Meta:
        model = Author
        fields = ("name",)


class CommentForm(ModelForm):
    class Meta:
        model = Comment
        fields = ("text", "author")


class ArticleForm(ModelForm):
    body = CharField(max_length=200, required=True, label='Текст', validators=(at_least_10,))

    def clean(self):
        cleaned_data = super().clean()
        print(cleaned_data)
        if cleaned_data['body'] == cleaned_data['title']:
            raise ValidationError('Текст в названии и теле статьи совпадает')
        return cleaned_data

    def clean_author(self):
        author = self.cleaned_data.get('author')
        if author.id == 1:
            raise ValidationError(f"У автора {author} слишком много статей!")
        return author

    class Meta:
        model = Article
        fields = "__all__"
