from django.contrib.auth import (
    authenticate, login, logout
)
from django.core.exceptions import ValidationError
from django.shortcuts import render, redirect
from .forms import RegisterForm, MyRegisterForm


def logout_view(request):
    logout(request)
    next = request.GET.get('next')
    if next:
        return redirect(next)
    return redirect('login')


def login_view(request):
    context = {}
    print(request.GET)
    if request.method == 'POST':
        username = request.POST.get("username")
        password = request.POST.get("pass")
        user = authenticate(
            request,
            username=username,
            password=password
        )
        if user:
            login(request, user)
            next = request.GET.get('next')
            if next:
                return redirect(next)
            return redirect('article_list')
        else:
            context['has_error'] = True
    return render(
        request=request,
        template_name='login.html',
        context=context
    )


def register_view(request, *args, **kwargs):
    if request.method == "POST":

        try:
            form = MyRegisterForm(data=request.POST)
            if form.is_valid():
                user = form.save()
                login(request, user)
                return redirect('article_list')
        except ValidationError as e:
            print(e)

    else:
        form = MyRegisterForm()
    return render(request, template_name='register.html', context={"form": form})
