from django.core.exceptions import ValidationError
from django.forms.models import ModelForm
from django.forms import CharField, Form

from articles.models import Article, Author, Comment


def at_least_10(string):
    if len(string) < 10:
        raise ValidationError("Имя слишком короткое")


class AuthorForm(ModelForm):
    name = CharField(max_length=200, required=True, label='Имя автора', validators=(at_least_10,))

    class Meta:
        model = Author
        fields = ("name",)


class CommentForm(ModelForm):
    class Meta:
        model = Comment
        fields = ("text", "author")


class ArticleForm(ModelForm):
    class Meta:
        model = Article
        fields = "__all__"


class SearchForm(Form):
    search = CharField(max_length=100, required=False, label="Найти")
