from django.urls import path
from .views.article_views import (
    ArticleDeleteView,
    ArticleUpdateView,
    ArticleCreateView,
    ArticleDetailView,
    ArticleListView
)

from .views.comment_views import (
    CommentCreateView,
    CommentUpdateView
)

from .views.author_views import (
    AuthorUpdateView,
    AuthorListView,
    AuthorDeleteView,
    AuthorCreateView
)


comments_routes = [
    path('articles/<int:pk>/comment/add',
         CommentCreateView.as_view(),
         name='create_comment'
         ),
    path('articles/<int:pk>/comment/update',
         CommentUpdateView.as_view(),
         name='update_comment'
         ),
]

articles_routes = [
    path(
        '',
        ArticleListView.as_view(),
        name="article_list"
    ),
    path(
        'article/<int:pk>/',
        ArticleDetailView.as_view(),
        name="article_detail"
    ),
    path(
        'article/create',
        ArticleCreateView.as_view(),
        name='article_create'
    ),
    path(
        'article/<int:pk>/update',
        ArticleUpdateView.as_view(),
        name='article_update'
    ),

    path(
        'article/<int:pk>/delete',
        ArticleDeleteView.as_view(),
        name='article_delete'
    ),
]

author_routes = [
    path(
        'create/',
        AuthorCreateView.as_view(),
        name="author_create"
    ),

    path(
        'authors/',
        AuthorListView.as_view(),
        name="author_list"
    ),

    path(
        'author/<int:pk>/update/',
        AuthorUpdateView.as_view(),
        name="author_update"
    ),

    path(
        'author/<int:pk>/delete/',
        AuthorDeleteView.as_view(),
        name="author_delete"
    )
]

urlpatterns = comments_routes
urlpatterns += author_routes
urlpatterns += articles_routes
