from django.contrib.auth import (
    authenticate, login, logout
)
from django.shortcuts import render, redirect


def logout_view(request):
    logout(request)
    return redirect('login')

def login_view(request):

    context = {}
    if request.method == 'POST':
        username = request.POST.get("username")
        password = request.POST.get("pass")
        user = authenticate(
            request,
            username=username,
            password=password
        )
        if user:
            login(request, user)
            return redirect('article_list')
        else:
            context['has_error'] = True
    return render(
        request=request,
        template_name='login.html',
        context=context
    )
