from django.urls import reverse, reverse_lazy

from articles.forms import AuthorForm
from articles.helpers.views import ListView, CreateView, UpdateView, DeleteView
from articles.models import Author


class AuthorListView(ListView):
    template_name = 'authors/list.html'
    model = Author
    context_object_name = 'authors'
    ordering = ['name']
    paginate_by = 5


class AuthorCreateView(CreateView):
    template_name = 'authors/create.html'
    model = Author
    form_class = AuthorForm
    redirect_url = reverse_lazy('author_list')


class AuthorUpdateView(UpdateView):
    template_name = 'authors/update.html'
    model = Author
    form_class = AuthorForm
    redirect_url = reverse_lazy('author_list')


class AuthorDeleteView(DeleteView):
    model = Author
    confirm_deletion = False
    redirect_url = reverse_lazy('author_list')

