from django.db import models


class Author(models.Model):
    name = models.CharField(max_length=50, null=False, verbose_name="Автор")

    def __str__(self):
        return self.name


class Article(models.Model):
    title = models.CharField(max_length=250, null=False)
    body = models.CharField(max_length=2000, null=True)
    author = models.ForeignKey(
        "articles.Author",
        on_delete=models.SET_NULL,
        null=True, related_name='articles')
    tags_old = models.ManyToManyField(
        'articles.Tag',
        related_name="articles_old",
        through='articles.ArticleTag',
        through_fields=('article', 'tag'),
        blank=True
    )
    tags = models.ManyToManyField(
        'articles.Tag',
        related_name="articles",
        blank=True
    )


class Comment(models.Model):
    article = models.ForeignKey(
        "articles.Article",
        related_name="comments",
        on_delete=models.CASCADE,
        verbose_name="Статья")
    text = models.TextField(max_length=400, verbose_name="Комментарий")
    author = models.CharField(max_length=40, null=True, blank=True, verbose_name="Автор", default="Аноним")
    created_at = models.DateTimeField(auto_now_add=True, verbose_name="Дата создания")
    updated_at = models.DateTimeField(auto_now=True, verbose_name="Дата изменения")

    def __str__(self):
        return self.text[:20]


class Tag(models.Model):
    name = models.CharField(max_length=31, verbose_name='Тег')
    created_at = models.DateTimeField(
        auto_now_add=True,
        verbose_name='Время создания'
    )

    def __str__(self):
        return self.name


class ArticleTag(models.Model):
    article = models.ForeignKey(
        'articles.Article',
        related_name='article_tags',
        on_delete=models.CASCADE,
        verbose_name="Статья")
    tag = models.ForeignKey(
        'articles.Tag',
        related_name='tag_articles',
        on_delete=models.CASCADE,
        verbose_name="Тег")

    def __str__(self):
        return f"{self.article} | {self.tag}"
