# Generated by Django 3.2.6 on 2021-08-12 15:20

from django.db import migrations


def transfer_tags(apps, schema_editor):
    Article = apps.get_model('articles.Article')
    for article in Article.objects.all():
        article.tags.set(article.tags_old.all())


def rollback_transfer(apps, schema_editor):
    Article = apps.get_model('articles.Article')
    for article in Article.objects.all():
        article.tags_old.set(article.tags.all())


class Migration(migrations.Migration):
    dependencies = [
        ('articles', '0009_article_tags_old'),
    ]

    operations = [
        migrations.RunPython(transfer_tags, rollback_transfer)
    ]
