from django.urls import path
from .views import LoginView, LogoutView, RegisterView, UserDetailView, UserChangeView, UserPasswordChangeView

urlpatterns = [
    path('accounts/login', LoginView.as_view(), name='user-login'),
    path('accounts/logout', LogoutView.as_view(), name='user-logout'),
    path('accounts/create/', RegisterView.as_view(), name="user-register"),
    path('accounts/<int:pk>/', UserDetailView.as_view(), name='user-detail'),
    path('accounts/<int:pk>/change', UserChangeView.as_view(), name='user-change'),
    path('accounts/<int:pk>/change-password', UserPasswordChangeView.as_view(), name='user-change-password')
]