from django.urls import path
from .views import (
    ArticleListView,
    ArticleDetailView,
    author_edit_view, author_delete_view, AuthorView, CreateArticleView, ArticleUpdateView, AuthorListView,
    ArticleCommentCreateView
)

urlpatterns = [
    path(
        '',
        ArticleListView.as_view(),
        name="article_list"
    ),
    path(
        'article/<int:pk>/',
        ArticleDetailView.as_view(),
        name="article_detail"
    ),
    path('articles/<int:pk>/comment/add',
         ArticleCommentCreateView.as_view(),
         name='create_comment'
         ),
    path(
        'article/create',
        CreateArticleView.as_view(),
        name='article_create'
    ),
    path(
        'article/<int:pk>/update',
        ArticleUpdateView.as_view(),
        name='article_update'
    ),
    path(
        'create/',
        AuthorView.as_view(),
        name="author_create"
    ),
    path(
        'authors/',
        AuthorListView.as_view(),
        name="author_list"
    ),

    path(
        'author/<int:pk>/update/',
        author_edit_view,
        name="author_update"
    ),

    path(
        'author/<int:pk>/delete/',
        author_delete_view,
        name="author_delete"
    )
]
