import { IngredientNames, Ingredients } from "@/interfaces/burger-interface";
import "./BuildControls.css";
import { BuildControl } from "@/components/BuildControls/BuildControl/BuildControl";
import { Dispatch, SetStateAction } from "react";

interface Props {
  ingredients: Ingredients;
  totalPrice: number;
  purchasable: boolean;
  handleLess: (key: IngredientNames) => void;
  handleMore: (key: IngredientNames) => void;
  setIsOpen: Dispatch<SetStateAction<boolean>>;
}

export function BuildControls({
  ingredients,
  totalPrice,
  purchasable,
  handleLess,
  handleMore,
  setIsOpen,
}: Props) {
  const ingrKeys = Object.keys(ingredients) as (keyof Ingredients)[];

  return (
    <div className="BuildControls">
      <p>Price: {totalPrice}</p>
      {ingrKeys.map((key, i) => (
        <BuildControl
          key={key + i}
          type={key}
          disabled={!ingredients[key]}
          handleLess={() => handleLess(key)}
          handleMore={() => handleMore(key)}
        />
      ))}
      <button className="OrderButton" disabled={!purchasable} onClick={() => setIsOpen(true)}>
        ORDER NOW
      </button>
    </div>
  );
}
