import { IngredientNames } from "@/interfaces/burger-interface";
import "./BuildControl.css";

interface Props {
  type: IngredientNames;
  disabled: boolean;
  handleLess: () => void;
  handleMore: () => void;
}

export function BuildControl({ type, disabled, handleLess, handleMore }: Props) {
  return (
    <div className="BuildControl">
      <div className="Label">{type}</div>
      <button className="Less" onClick={handleLess} disabled={disabled}>
        Less
      </button>
      <button className="More" onClick={handleMore}>
        More
      </button>
    </div>
  );
}
