using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using Microsoft.AspNetCore.Identity;
using Microsoft.AspNetCore.Mvc.Rendering;
using webinar65.Models;

namespace webinar65.ViewModels
{
    public class UserCreateViewModel
    {
        [Required]
        public string Username { get; set; }

        [Required]
        public string Email { get; set; }

        [Required]
        public string Password { get; set; }

        [Required]
        public string RoleName { get; set; }

        public List<SelectListItem> Roles { get; set; }

        public UserCreateViewModel()
        {

        }

        public UserCreateViewModel(List<IdentityRole> roles)
        {
            Roles = roles.Select(r => new SelectListItem
            {
                Text = r.Name,
                Value = r.Name
            }).ToList();
        }
    }
}
