using System.Threading.Tasks;
using Microsoft.AspNetCore.Identity;
using Microsoft.AspNetCore.Mvc;
using webinar65.Models;
using webinar65.ViewModels;

namespace webinar65.Controllers
{
    public class AccountController : Controller
    {
        private UserManager<User> _userManager;
        private SignInManager<User> _signInManager;

        public AccountController(UserManager<User> userManager, SignInManager<User> signInManager)
        {
            _userManager = userManager;
            _signInManager = signInManager;
        }

        [HttpGet]
        public IActionResult Login(string returnUrl)
        {
            ViewBag.returnUrl = returnUrl;
            return View();
        }

        [HttpPost]
        public async Task<IActionResult> Login(LoginViewModel model, string returnUrl)
        {
            if (ModelState.IsValid)
            {
                var user = await _userManager.FindByEmailAsync(model.Email);
                var result = await _signInManager.PasswordSignInAsync(
                    user.UserName,
                    model.Password,
                    false,
                    false
                );

                if (result.Succeeded)
                    return Redirect(returnUrl ?? "/");

                ModelState.AddModelError(nameof(LoginViewModel.Email), "Invalid email or password");
            }

            return View(model);
        }

        public async Task<IActionResult> Logout()
        {
            if (_signInManager.IsSignedIn(User))
            {
                await _signInManager.SignOutAsync();
            }

            return RedirectToAction("Login");
        }

        public IActionResult AccessDenied(string returnUrl)
        {
            ViewBag.returnUrl = returnUrl;
            return View();
        }
    }
}
