using System.IO;
using Microsoft.AspNetCore.Http;
using MyCities.Models;

namespace MyCities.ViewModels
{
    public class PersonCreateViewModel
    {
        public string FullName { get; set; }
        public string NickName { get; set; }
        public IFormFile Avatar { get; set; }

        public string GetFilePath()
        {
            return Path.Combine(
                Directory.GetCurrentDirectory(),
                "wwwroot",
                "images",
                Avatar.FileName
            );
        }

        public string GetAvatarImagePath()
        {
            return Path.Combine(
                "images",
                Avatar.FileName
            );
        }

        public Person GetPerson()
        {
            return new Person
            {
                FullName = FullName,
                NickName = NickName,
                AvatarImagePath = GetAvatarImagePath()
            };
        }
    }
}
