using System.Collections.Generic;
using MyCities.Models;

namespace MyCities.Repositories
{
    public class InMemoryCityRepository : ICityRepository
    {
        private List<City> _cities = new List<City>
        {
            new City
            {
                Name = "Almaty",
                Country = "Kazakhstan",
                Population = 3000000
            },
            new City
            {
                Name = "Moscow",
                Country = "Russia",
                Population = 12000000
            },
            new City
            {
                Name = "New York",
                Country = "USA",
                Population = 7000000
            }
        };

        public List<City> Cities => _cities;

        public void Add(City city)
        {
            _cities.Add(city);
        }
    }

}
