using System.Collections.Generic;
using System.Linq;
using MyCities.Models;

namespace MyCities.Repositories
{
    public class CityRepository : ICityRepository
    {
        private MyCitiesDbContext _dbContext;

        public List<City> Cities => _dbContext.Cities.ToList();

        public CityRepository(MyCitiesDbContext dbContext)
        {
            _dbContext = dbContext;
        }

        public void Add(City city)
        {
            _dbContext.Cities.Add(city);
            _dbContext.SaveChanges();
        }
    }
}
