using Microsoft.AspNetCore.Razor.TagHelpers;

namespace MyCities.Infrastructure.TagHelpers
{
    [HtmlTargetElement("button", Attributes = "hlp-color", ParentTag = "form")]
    public class ButtonTagHelper : TagHelper
    {
        public string HlpColor { get; set; }

        public override void Process(TagHelperContext context, TagHelperOutput output)
        {
            output.Attributes.SetAttribute("class", $"btn btn-{HlpColor}");
        }
    }
}
