using System.IO;
using Microsoft.AspNetCore.Mvc;
using MyCities.Models;
using MyCities.Repositories;
using MyCities.ViewModels;

namespace MyCities.Controllers
{
    public class PersonController : Controller
    {
        private IPersonRepository _repository;

        public PersonController(IPersonRepository repository)
        {
            _repository = repository;
        }

        public IActionResult Index()
        {
            return View(_repository.Persons);
        }

        [HttpGet]
        public IActionResult Create()
        {
            return View();
        }

        [HttpPost]
        public IActionResult Create(PersonCreateViewModel viewModel)
        {
            using (var stream = new FileStream(viewModel.GetFilePath(), FileMode.Create))
            {
                viewModel.Avatar.CopyTo(stream);
            }
            _repository.Add(viewModel.GetPerson());
            return RedirectToAction("Index");
        }
    }
}
