using Microsoft.AspNetCore.Mvc;
using MyCities.Models;
using MyCities.Repositories;

namespace MyCities.Controllers
{
    public class HomeController : Controller
    {
        private ICityRepository _cityRepository;

        public HomeController(ICityRepository cityRepository)
        {
            _cityRepository = cityRepository;
        }

        public IActionResult Index()
        {
            return View(_cityRepository.Cities);
        }

        [HttpGet]
        public IActionResult Create()
        {
            return View();
        }

        [HttpPost]
        public IActionResult Create(City city)
        {
            _cityRepository.Add(city);
            return RedirectToAction("Index");
        }
    }
}
