package com.example.final_exam_l.service;

import com.example.final_exam_l.dto.add.UserAddDTO;
import com.example.final_exam_l.entity.User;
import com.example.final_exam_l.exception.ResourceNotFoundException;
import com.example.final_exam_l.exception.UserAlreadyExistsException;
import com.example.final_exam_l.repository.UserRepository;
import lombok.RequiredArgsConstructor;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
@RequiredArgsConstructor
public class UserService {
    private final UserRepository repository;
    private final PasswordEncoder encoder;

    public User register(UserAddDTO dto){
        if(repository.existsByEmail(dto.getEmail()) || repository.existsByLogin(dto.getLogin()))
            throw new UserAlreadyExistsException();
        User user = User.builder()
                .login(dto.getLogin())
                .email(dto.getEmail())
                .password(encoder.encode(dto.getPassword()))
                .build();
        return repository.save(user);
    }

    public User findByEmail(String email){
        return repository.findByEmail(email).orElseThrow(() -> {
            return new ResourceNotFoundException("Пользователь", email);
        });
    }

    public boolean existByEmail(String email){
        return repository.existsByEmail(email);
    }

    public boolean existByLogin(String login){
        return repository.existsByLogin(login);
    }
}
