package com.example.final_exam_l.service;

import com.example.final_exam_l.entity.Place;
import com.example.final_exam_l.entity.PlacePhoto;
import com.example.final_exam_l.repository.PlacePhotoRepository;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

@Service
@RequiredArgsConstructor
public class PlacePhotoService {
    private final PlacePhotoRepository repository;
    private final UserService userService;

    public PlacePhoto add(String email, String path, Place place){
        PlacePhoto newFile = repository.save(PlacePhoto.builder()
                .filePath(path)
                .place(place)
                .user(userService.findByEmail(email))
                .build());
        return newFile;
    }
}
