package com.example.final_exam_l.entity;

import javax.validation.constraints.NotNull;
import lombok.*;

import javax.persistence.*;

@Getter
@Setter
@Table(name = "photos")
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class PlacePhoto {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;

    @Column
    @NotNull
    private String filePath;

    @Column
    @NotNull
    @Builder.Default
    private boolean isMain = false;

    @NotNull
    @ManyToOne
    private Place place;

    @NotNull
    @ManyToOne
    private User user;
}
