package com.example.final_exam_l.entity;

import javax.validation.constraints.NotNull;
import lombok.*;

import javax.persistence.*;
import java.util.ArrayList;
import java.util.List;

@Getter
@Setter
@Table(name = "places")
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class Place {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;

    @Column
    @NotNull
    private String name;

    @Column
    @NotNull
    private String description;

    @Column
    @NotNull
    @Builder.Default
    private double rating = 0.0;

    @Column
    @NotNull
    @Builder.Default
    private boolean isDel = false;

    @OneToOne
    private PlacePhoto placePhoto;

//    @Column
//    private String mainPhoto;

    @NotNull
    @ManyToOne
    private User user;

    @OneToMany(fetch = FetchType.LAZY, mappedBy = "place")
    @Builder.Default
    @ToString.Exclude
    List<PlacePhoto> photos = new ArrayList<>();

    @OneToMany(fetch = FetchType.LAZY, mappedBy = "place")
    @Builder.Default
    @ToString.Exclude
    List<Review> reviews = new ArrayList<>();
}
