package com.example.final_exam_l.dto.add;

import lombok.AllArgsConstructor;
import lombok.Getter;

import javax.persistence.Column;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Getter
@AllArgsConstructor
public class ReviewAddDTO {
    @NotNull
    @Size(min = 2, message = "Минимальная длина комментария - два символа")
    private String description;

    @NotNull
    @Min(value = 1, message = "Минимальная оценка 1")
    @Max(value = 5, message = "Максимальная оценка 5")
    private Integer grade;
}
