package com.example.final_exam_l.dto;

import com.example.final_exam_l.entity.User;
import lombok.*;

@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class UserDTO {
    private Integer id;
    private String login;
    private String email;
    private String password;
    private String role;
    private boolean active;

    public static UserDTO from(User user){
        return UserDTO.builder()
                .id(user.getId())
                .login(user.getLogin())
                .email(user.getEmail())
                .password(user.getPassword())
                .role(user.getRole())
                .active(user.isActive())
                .build();
    }
}
