package com.example.final_exam_l.dto;

import com.example.final_exam_l.entity.Place;
import com.example.final_exam_l.entity.Review;
import com.example.final_exam_l.entity.User;
import com.sun.istack.NotNull;
import lombok.*;

import javax.persistence.*;

@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ReviewDTO {
    private Integer id;
    private String description;
    private Integer grade;
    private boolean isDel;
    @ToString.Exclude
    private PlaceDTO place;
    @ToString.Exclude
    private UserDTO user;

    public static ReviewDTO from(Review review){
        return ReviewDTO.builder()
                .id(review.getId())
                .description(review.getDescription())
                .grade(review.getGrade())
                .place(PlaceDTO.from(review.getPlace()))
                .user(UserDTO.from(review.getUser()))
                .build();
    }
}
