package com.example.final_exam_l.service;

import com.example.final_exam_l.dto.add.ReviewAddDTO;
import com.example.final_exam_l.entity.Place;
import com.example.final_exam_l.entity.Review;
import com.example.final_exam_l.exception.ResourceNotFoundException;
import com.example.final_exam_l.repository.ReviewRepository;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

@Service
@RequiredArgsConstructor
public class ReviewService {
    private final ReviewRepository repository;
    private final UserService userService;
    private final PlaceService placeService;

    public Review findOne(int id){
        return repository.findById(id).orElseThrow(() -> {
            return new ResourceNotFoundException("Отзыв", id);
        });
    }

    public boolean isUnique(int placeId, int userId){
        return repository.existsByPlaceIdAndUserId(placeId, userId);
    }

    public Review add(ReviewAddDTO dto, String email, Place place){
        Review review = repository.save(Review.builder()
                .description(dto.getDescription())
                .grade(dto.getGrade())
                .user(userService.findByEmail(email))
                .place(place)
                .build());
        placeService.rating(place.getId());
        return review;
    }

    public void delete(int id, int placeId){
        Review review = findOne(id);
        repository.delete(review);
        placeService.rating(placeId);
    }
}
