package com.example.final_exam_l.service;

import com.example.final_exam_l.dto.add.PlaceAddDTO;
import com.example.final_exam_l.entity.Place;
import com.example.final_exam_l.entity.Review;
import com.example.final_exam_l.exception.ResourceNotFoundException;
import com.example.final_exam_l.repository.PlaceRepository;
import lombok.RequiredArgsConstructor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;


@Service
@RequiredArgsConstructor
public class PlaceService {
    private final PlaceRepository repository;
    private final UserService userService;

    public Place findOne(int id){
        return repository.findById(id).orElseThrow(() -> {
            return new ResourceNotFoundException("Завдеение", id);
        });
    }
    public Page<Place> all(Pageable pageable){
        return repository.findAll(pageable);
    }

    public Page<Place> filter(Pageable pageable, String name){
        return repository.findAllByNameContains(pageable, name);
    }

    public boolean isUnique(String name){
        return repository.existsByName(name);
    }

    public boolean isPhoto(MultipartFile multipartFile) {
        String name = multipartFile.getOriginalFilename();
        String[] words = name.split("\\.");
        String format = words[words.length - 1];
        return format.equals("png") || format.equals("jpg");
    }

    public Place add(PlaceAddDTO dto, String email){
        Place place = repository.save(Place.builder()
                .name(dto.getName())
                .description(dto.getDescription())
                .user(userService.findByEmail(email))
                .build());
        return place;
    }

    public void delete(int id){
        Place place = findOne(id);
        place.setDel(true);
        repository.save(place);
    }

    public Place save(Place place){
        return repository.save(place);
    }

    public void rating(int id){
        int commonGrade = findOne(id).getReviews().stream().mapToInt(Review::getGrade).sum();
        int amount = findOne(id).getReviews().size();
        Place place = findOne(id);
        place.setRating(commonGrade / amount);
        repository.save(place);
    }
}
