package com.example.final_exam_l.entity;

import com.example.final_exam_l.enumiration.UserRole;
import javax.validation.constraints.NotNull;
import lombok.*;

import javax.persistence.*;
import java.util.ArrayList;
import java.util.List;

@Table(name = "users")
@Entity
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class User {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;

    @Column
    @NotNull
    private String login;

    @Column
    @NotNull
    private String email;

    @Column
    @NotNull
    private String password;

    @Column
    @NotNull
    @Builder.Default
    private String role = UserRole.USER.name();

    @Column
    @NotNull
    @Builder.Default
    private boolean active = true;

    @OneToMany(fetch = FetchType.LAZY, mappedBy = "user")
    @Builder.Default
    @ToString.Exclude
    List<Place> places = new ArrayList<>();
}
