package com.example.final_exam_l.dto;

import com.example.final_exam_l.entity.Place;
import lombok.*;

@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class PlaceDTO {
    private Integer id;
    private String name;
    private String description;
    private double rating;
    @ToString.Exclude
    private UserDTO user;

    public static PlaceDTO from(Place place){
        return PlaceDTO.builder()
                .id(place.getId())
                .name(place.getName())
                .description(place.getDescription())
                .rating(place.getRating())
                .user(UserDTO.from(place.getUser()))
                .build();
    }
}
