package com.example.final_exam_l.controller;

import com.example.final_exam_l.dto.add.UserAddDTO;
import com.example.final_exam_l.service.UserService;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.validation.Valid;
import java.security.Principal;

@Controller
@RequiredArgsConstructor
public class UserController {
    private final UserService service;

    @GetMapping("/register")
    public String register(){
        return "user/register";
    }

    @PostMapping("/register")
    public String register(@Valid UserAddDTO dto,
                           BindingResult result,
                           RedirectAttributes attributes){
        attributes.addFlashAttribute("dto", dto);
        if (result.hasFieldErrors()){
            attributes.addFlashAttribute("errors", result.getFieldErrors());
            return "redirect:/register";
        }
        else if (service.existByEmail(dto.getEmail())){
            attributes.addFlashAttribute("emailError", "Пользователь с мейлом "
                    + dto.getEmail() + " существует. Выберите другой");
            return "redirect:/register";
        }
        else if (service.existByLogin(dto.getLogin())){
            attributes.addFlashAttribute("loginError", "Пользователь с логином "
                    + dto.getLogin() + " существует. Выберите другой");
            return "redirect:/register";
        }
        service.register(dto);
        attributes.addFlashAttribute("success", "Регистрация прошла успешно! Вам необходимо авторизоваться");
        return "redirect:/login";
    }

    @GetMapping("/login")
    public String login(@RequestParam(required = false, defaultValue = "false") Boolean error, Model model){
        model.addAttribute("error", error);
        return "user/login";
    }

    @GetMapping("/cabinet")
    public String cabinet(Model model, Principal principal){
        model.addAttribute("user", service.findByEmail(principal.getName()));
        return "user/cabinet";
    }

    @PostMapping("/logout")
    public String logOut(){
        return "redirect:/login";
    }
}
