import cors from 'cors';
import { randomUUID } from 'crypto';
import express from 'express';
import expressWs from 'express-ws';

const PORT = 8000;

const { app } = expressWs(express());

app.use(cors());

const activeConnections: any = {};

app.ws('/chat', function (ws) {
  console.log('client connected');
  const id = randomUUID();
  console.log('client connected! id=', id);

  activeConnections[id] = ws;

  ws.on('close', () => {
    console.log('client disconnected! id=', id);
    delete activeConnections[id];
  });

  let username = '';

  ws.on('message', (msg: string) => {
    const decodedMessage = JSON.parse(msg);

    switch (decodedMessage.type) {
      case 'SET_USERNAME':
        username = decodedMessage.username;
        break;

      case 'CREATE_MESSAGE':
        Object.keys(activeConnections).forEach((connId) => {
          const conn = activeConnections[connId];
          
          conn.send(
            JSON.stringify({
              type: 'NEW_MESSAGE',
              message: {
                username,
                text: decodedMessage.text,
              },
            }),
          );
        });

        break;
      default:
        console.log('Unknown message type:', decodedMessage.type);
    }
  });
});

app.listen(PORT, () => {
  console.log(`Server started on ${PORT} port!`);
});
