import { Injectable, NotFoundException } from '@nestjs/common';
import { CreateUserDto } from './dto/create-user.dto';
import { InjectRepository } from '@nestjs/typeorm';
import { User } from './entities/user.entity';
import { Repository } from 'typeorm';
import * as bcrypt from 'bcrypt';

const SALT_WORK_FACTOR = 10;

@Injectable()
export class UserService {
  constructor(@InjectRepository(User) private userRepo: Repository<User>) {}

  async register(createUserDto: CreateUserDto) {
    const salt = await bcrypt.genSalt(SALT_WORK_FACTOR);
    createUserDto.password = await bcrypt.hash(createUserDto.password, salt);
    const user = this.userRepo.create(createUserDto);
    await this.userRepo.save(user);
    return user;
  }

  async login(createUserDto: CreateUserDto) {
    const user = await this.userRepo.findOneBy({
      username: createUserDto.username,
    });

    if (!user) new NotFoundException('User not found');

    // password = 2131
    const isMatch = await bcrypt.compare(
      createUserDto.password,
      user?.password || '',
    );

    if (isMatch) {
      return "SUCCESS LOGIN";
    } else {
      return null;
    }
  }

  logout() {
    return `This action returns a user`;
  }
}
