import { InjectRepository } from '@nestjs/typeorm';
import { CreateProductDto } from './dto/create-product.dto';
import { Product } from './entities/product.entity';
import { Repository } from 'typeorm';
import { Injectable, NotFoundException } from '@nestjs/common';
import { Category } from 'src/category/entities/category.entity';

@Injectable()
export class ProductService {
  constructor(
    @InjectRepository(Product) private productRepo: Repository<Product>,
    @InjectRepository(Category) private categoryRepo: Repository<Category>,
  ) {}

  async create(createProductDto: CreateProductDto): Promise<Product> {
    const category = await this.categoryRepo.findOneBy({
      id: createProductDto.categoryId,
    });

    if (!category) new NotFoundException('Category not found');

    const product = this.productRepo.create({
      ...createProductDto,
      categoryId: category?.id,
    });
    await this.productRepo.save(product);
    return product;
  }

  async findAll(): Promise<Product[]> {
    return await this.productRepo.find();
  }

  async findOne(id: number): Promise<Product | null> {
    return await this.productRepo.findOneBy({ id });
  }

  async remove(id: number): Promise<number> {
    await this.productRepo.delete({ id });
    return id;
  }
}
